// DeleteCard.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "DeleteCard.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDeleteCard dialog


CDeleteCard::CDeleteCard(CWnd* pParent /*=NULL*/)
	: CDialog(CDeleteCard::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDeleteCard)
	m_sStartCardNo = _T("");
	m_sEndCardNo = _T("");
	//}}AFX_DATA_INIT
}

CDeleteCard::CDeleteCard(IApplication *pApp):CDialog(CDeleteCard::IDD,NULL)
{
	pApplication = pApp;
}
void CDeleteCard::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDeleteCard)
	DDX_Control(pDX, IDC_CARDLIST, m_CardList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Text(pDX, IDC_START_CARD_DEL, m_sStartCardNo);
	DDX_Text(pDX, IDC_END_CAR_DEL, m_sEndCardNo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDeleteCard, CDialog)
	//{{AFX_MSG_MAP(CDeleteCard)
	ON_BN_CLICKED(IDDELETE, OnDelete)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_BN_CLICKED(IDC_BTN_BULK_DELETE, OnBtnBulkDelete)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDeleteCard message handlers
BOOL CDeleteCard::OnInitDialog() 
{
	CDialog::OnInitDialog();

	
	
	LoadAccounts();//load the account list in WP-CS database
				
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}
void CDeleteCard ::LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				m_AcctList.SetItemData(m_AcctList.AddString(pAccount->AccountName),pAccount->AccountID) ;
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
}

void CDeleteCard :: LoadSubAccounts()
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
				
		//select AccountID
		int index_Acct = m_AcctList.GetCurSel();
		
		long lAccountID = m_AcctList.GetItemData(index_Acct);		

		if(lAccountID <= 0)
		{
			AfxMessageBox(L"Select Account!");
			return;
		}
		pApplication->GetSubAccountsByAccountID(lAccountID, &vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pSubAccount= NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount!= NULL)
			{
				m_SubAcctList.SetItemData( m_SubAcctList.AddString(pSubAccount->AccountName),pSubAccount->AccountID );
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	
	//m_AccountList.SetCurSel(0);
	
}

void CDeleteCard ::LoadCardsList()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctName;
		m_AcctList.GetLBText(index,sAcctName);
		BSTR bstrAcctName = sAcctName.AllocSysString();

		//select sub account name 
		int index_sub = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(index_sub,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();


		_variant_t vCards;
		vCards.Clear();
		// get Card details in WP-CS database server by specified account
		pApplication->GetCardsByAccountName(bstrAcctName, bstrSubAcctName, &vCards); 
				
		if(vCards.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ICard *pCard = NULL;
		
		COleSafeArray sa(vCards);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ICard,(void**)&pCard);
			if (pCard != NULL)
			{
				m_CardList.AddString(pCard->CardNumber);			
				pCard->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
}
void CDeleteCard::OnDelete() 
{
		BSTR bstrAcctName;
		BSTR bstrSubAcctName;
		BSTR bstrCardNumber;
	//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}

		//select sub account name 
		int index_sub = m_SubAcctList.GetCurSel();
		CString sSubAcctName;

		if (index_sub <0)
			bstrSubAcctName = SysAllocString(L"");
		else
		{
			m_SubAcctList.GetLBText(index_sub,sSubAcctName);
			bstrSubAcctName = sSubAcctName.AllocSysString();
		}
		
	//select card number
		int index_card = m_CardList.GetCurSel();
		CString sCardno;
		if (index_card <0)
			bstrCardNumber = SysAllocString(L"");
		else
		{
			m_CardList.GetLBText(index_card,sCardno);
			bstrCardNumber = sCardno.AllocSysString();
		}
		long lstatus;
		pApplication->DeleteCard(bstrCardNumber,bstrAcctName, bstrSubAcctName, &lstatus);
		//get the output error values		
		if ( lstatus == 102)
		{
			AfxMessageBox(L"Invalid Card Number");
			return;
		}
		if( lstatus == 105)
		{
			AfxMessageBox(L"Invalid Account");
			return;
		}
		

		if (lstatus == 1)
		{
			AfxMessageBox(L"Card Deletion Failed");
			return;
		}
		if ( lstatus == 0)
		{
			AfxMessageBox(L"Card Deletion Succeded");
			CDialog::OnOK();
		}
		
		
}

void CDeleteCard::OnSelchangeAcctlist() 
{
	m_CardList.ResetContent();
	m_SubAcctList.ResetContent();
	LoadSubAccounts();
	
}

void CDeleteCard::OnSelchangeSubAcctlist() 
{
	m_CardList.ResetContent();
	LoadCardsList();
	
}

void CDeleteCard::OnBtnBulkDelete() 
{
	UpdateData();
	int index_Account = m_AcctList.GetCurSel();
	CString sAcctName;
	if (index_Account <0)
	{
		AfxMessageBox(L"Select An Account");
	}
	else
	{
		m_AcctList.GetLBText(index_Account,sAcctName);

		long lAcctID = m_AcctList.GetItemData(index_Account);
		//select AccountID
		int index_SubAcct = m_SubAcctList.GetCurSel();		
		long lSubAccountID = m_SubAcctList.GetItemData(index_SubAcct);

		/*
		_variant_t vAccounts;
		pApplication->GetAccounts(&vAccounts);
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sCurrAcctName = CString(((LPWSTR)pAccount->AccountName));
				if(sAcctName == sCurrAcctName)
				{
					lAcctID = pAccount->AccountID;
				}
			}
			pDisp->Release();
		}
		*/
		
		long lCardNumStart=_wtoi(m_sStartCardNo);
		long lCardNumEnd=_wtoi(m_sEndCardNo);
		
		int iOperID;
		BSTR bstrOperName;

		pApplication->GetCurrentOperator(&iOperID, &bstrOperName);

		pApplication->BulkDeleteCards(m_sStartCardNo.AllocSysString(), m_sEndCardNo.AllocSysString(), lAcctID, lSubAccountID, iOperID, bstrOperName);

		CDialog::OnOK();
	}
}
